package ru.yandex.direct.jobs.interceptors;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * JobLoggingInterceptor не будет писать в INFO сообщения о старте и финише джобы,
 * если джоба помечена этой аннотацией.
 * <p>
 * Имеет смысл использовать, если джоба вызывается довольно часто, но при этом её работоспособность
 * можно проверить по другим признакам (собственные записи в лог, juggler-события).
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface IgnoreStartFinishLogging {
}
