package ru.yandex.direct.jobs.interceptors;

import javax.annotation.Nonnull;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feature.service.DirectAuthContextService;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.scheduler.JobInterceptor;
import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.direct.scheduler.support.WrappedJob;

/**
 * Подчищаем некоторые компоненты со стейтом в TLS, расчитывающие на использование в web
 */
@Component
public class JobCleanerIntercepter implements JobInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(JobCleanerIntercepter.class);

    private final FeatureService featureService;
    private final DirectAuthContextService directAuthContextService;

    public JobCleanerIntercepter(FeatureService featureService, DirectAuthContextService directAuthContextService) {
        this.featureService = featureService;
        this.directAuthContextService = directAuthContextService;
    }

    @Nonnull
    @Override
    public WrappedJob wrap(WrappedJob code, BaseDirectJob originalJob) {
        return () -> {
            try {
                code.run();
            } finally {
                logger.debug("Job clearing start");
                featureService.clearCaches();
                LocaleContextHolder.resetLocaleContext();
                directAuthContextService.clearThreadLocal();
            }
        };
    }
}
