package ru.yandex.direct.jobs.interceptors;

import java.time.Duration;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.jobs.util.juggler.JobsAppJugglerChecksProvider;
import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.JugglerSender;
import ru.yandex.direct.scheduler.JobInterceptor;
import ru.yandex.direct.scheduler.support.BaseDirectJob;
import ru.yandex.direct.scheduler.support.WrappedJob;

/**
 * Отправка "OK" в juggler-мониторинг после успешного завершения задачи
 */
@Component
@ParametersAreNonnullByDefault
public class JobJugglerMonitoringInterceptor implements JobInterceptor {
    private final Duration eventsTimeout = Duration.ofMinutes(10);

    private JugglerSender jugglerSender;
    private JobsAppJugglerChecksProvider jobsAppJugglerChecksProvider;

    @Autowired
    public JobJugglerMonitoringInterceptor(JugglerSender jugglerSender,
                                           JobsAppJugglerChecksProvider jobsAppJugglerChecksProvider) {
        this.jugglerSender = jugglerSender;
        this.jobsAppJugglerChecksProvider = jobsAppJugglerChecksProvider;
    }

    @Nonnull
    @Override
    public WrappedJob wrap(WrappedJob code, BaseDirectJob originalJob) {
        return () -> {
            code.run();
            JugglerEvent event = jobsAppJugglerChecksProvider.getEvent(originalJob);
            if (event != null) {
                jugglerSender.sendEvent(event, eventsTimeout);
            }
        };
    }
}
