package ru.yandex.direct.jobs.internal;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.Objects;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class CryptaSegmentDescriptor {

    private final String cryptaId;
    private final String keywordId;
    private final String segmentId;

    private CryptaSegmentDescriptor(String cryptaId, String keywordId, String segmentId) {
        //noinspection ConstantConditions
        checkArgument(cryptaId != null, "cryptaId must not be null");
        //noinspection ConstantConditions
        checkArgument(keywordId != null, "keywordId must not be null");
        //noinspection ConstantConditions
        checkArgument(segmentId != null, "segmentId must not be null");
        this.cryptaId = cryptaId;
        this.keywordId = keywordId;
        this.segmentId = segmentId;
    }

    public static CryptaSegmentDescriptor createForGroup(String cryptaId) {
        return new CryptaSegmentDescriptor(cryptaId, "0", "0");
    }

    public static CryptaSegmentDescriptor create(String cryptaId, String keywordId, String segmentId) {
        return new CryptaSegmentDescriptor(cryptaId, keywordId, segmentId);
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public String getKeywordId() {
        return keywordId;
    }

    public String getSegmentId() {
        return segmentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CryptaSegmentDescriptor that = (CryptaSegmentDescriptor) o;
        return Objects.equal(cryptaId, that.cryptaId) &&
                Objects.equal(keywordId, that.keywordId) &&
                Objects.equal(segmentId, that.segmentId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(cryptaId, keywordId, segmentId);
    }

}
