package ru.yandex.direct.jobs.internal.model

import ru.yandex.direct.core.entity.banner.model.InternalBanner
import ru.yandex.direct.core.entity.internalads.Constants
import ru.yandex.direct.mail.EmailAddress
import ru.yandex.direct.mail.MailMessage

const val SUBJECT: String = "Нет статуса по модерации"
val EMAIL_ADDRESS_FROM =
    EmailAddress(Constants.NOTIFICATIONS_FROM_EMAIL, "InternalBannerModerationStuckNotificationJob")

fun createMessageBody(banners: List<InternalBanner>, duration: Long): String {
    val bannersString = banners.joinToString("\n") { banner -> "${banner.id}:\t${banner.statusModerate}" }

    return "Здравствуйте!\nСледующие баннеры были отправлены на модерацию более $duration часов назад," +
            " но по ним не был получен статус о прохождении модерации:\nid баннера:\tтекущий статус модерации в базе" +
            "\n$bannersString"
}

class BannerModerationStuckMessage(val banners: List<InternalBanner>, val duration: Long) : MailMessage(
    EMAIL_ADDRESS_FROM, Constants.NOTIFICATIONS_EMAIL_ADDRESS_TO, SUBJECT,
    createMessageBody(banners, duration)
)
