package ru.yandex.direct.jobs.internal.model;

import ru.yandex.direct.mail.EmailAddress;
import ru.yandex.direct.mail.MailMessage;

import static ru.yandex.direct.core.entity.internalads.Constants.MAIL_PERSONAL;
import static ru.yandex.direct.core.entity.internalads.Constants.NOTIFICATIONS_FROM_EMAIL;

public class NotificationsUrlMonitoringMailMessage extends MailMessage {
    private static final String NOTIFICATIONS_EMAIL = "banana-direct-alert@yandex-team.ru";

    public NotificationsUrlMonitoringMailMessage(String subject, String messageBody) {
        super(getFromEmail(), getToEmail(), subject, messageBody);
    }

    private static EmailAddress getFromEmail() {
        return new EmailAddress(NOTIFICATIONS_FROM_EMAIL, MAIL_PERSONAL);
    }

    private static EmailAddress getToEmail() {
        return new EmailAddress(NOTIFICATIONS_EMAIL, MAIL_PERSONAL);
    }

    @Override
    public String toString() {
        return getSubject() + "\n\n" + getMessageBody();
    }
}
