package ru.yandex.direct.jobs.internal.model

import ru.yandex.direct.core.entity.internalads.model.BannerUnreachableUrl

interface StructureOfBanners<T>{
    val campaignId: Long
    val campaignName: String
    val bannersByTemplateId: Map<Long, List<T>>

    companion object {
        @JvmStatic
        fun comparingByCampaignId(): Comparator<StructureOfBanners<*>> = Comparator.comparing { it.campaignId }
    }
}

data class StructureOfBannerIds(
    override val campaignId: Long,
    override val campaignName: String,
    override val bannersByTemplateId: Map<Long, List<Long>>,
) : StructureOfBanners<Long>

data class StructureOfUnavailableBanners(
    override val campaignId: Long,
    override val campaignName: String,
    override val bannersByTemplateId: Map<Long, List<BannerUnreachableUrl>>,
) : StructureOfBanners<BannerUnreachableUrl>
