package ru.yandex.direct.jobs.logs.configuration;

import java.util.List;

import one.util.streamex.IntStreamEx;

import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.direct.ytwrapper.model.YtCluster;

public abstract class YtBsExportLogParametersSource implements ParametersSource<YtLogParameter> {
    private static final String SEPARATOR = "---";
    abstract List<YtCluster> getYtClusters();

    @Override
    public List<YtLogParameter> getAllParamValues() {
        return IntStreamEx.range(0, YtLogParameter.WORKERS_NUM).boxed()
                .cross(getYtClusters())
                .mapKeyValue(YtLogParameter::new)
                .toList();
    }

    @Override
    public String convertParamToString(YtLogParameter paramValue) {
        return paramValue.getWorkerNum() + SEPARATOR + paramValue.getYtCluster().getName();
    }

    @Override
    public YtLogParameter convertStringToParam(String string) {
        String[] parts = string.split(SEPARATOR, 2);
        int workerNum = Integer.parseInt(parts[0]);
        YtCluster ytCluster = YtCluster.parse(parts[1]);

        YtLogParameter ytLogParameter = new YtLogParameter(workerNum, ytCluster);
        setupConsumer(ytLogParameter);
        return ytLogParameter;
    }

    abstract void setupConsumer(YtLogParameter parameter);
}
