package ru.yandex.direct.jobs.logs.model;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

import static com.google.common.base.Preconditions.checkNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;

public class BsExportLogRow {
    private static final byte[] LOG_TYPE = "bsexport.log".getBytes(StandardCharsets.UTF_8);

    private Long cid;
    private Long pid;
    private String level;
    private Long reqid;
    private String uuid;
    private Long shard;
    private String parType;
    private Long iterId;
    private String logHost;
    private Long actualInDirectDbAt;
    private String logTime;
    private int dataBegin;
    private int dataEnd;
    private byte[] source;
    private String data;

    public void setCid(Long cid) {
        this.cid = cid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setReqid(Long reqid) {
        this.reqid = reqid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setShard(Long shard) {
        this.shard = shard;
    }

    public void setParType(String parType) {
        this.parType = parType;
    }

    public void setIterId(Long iterId) {
        this.iterId = iterId;
    }

    public void setLogHost(String logHost) {
        this.logHost = logHost;
    }

    public void setActualInDirectDbAt(Long actualInDirectDbAt) {
        this.actualInDirectDbAt = actualInDirectDbAt;
    }

    public void setDataPos(byte[] source, int[] pos) {
        dataBegin = pos[0];
        dataEnd = pos[1];
        this.source = source;
        data = null;
    }

    public void setData(String data) {
        this.data = data;
        dataBegin = dataEnd = 0;
        source = null;
    }

    public byte[] getData() {
        if (source != null && dataBegin > 0 && dataEnd > 0) {
            return Arrays.copyOfRange(source, dataBegin, dataEnd);
        } else if (data != null) {
            return data.getBytes(StandardCharsets.UTF_8);
        } else {
            throw new IllegalStateException("Data was not set");
        }
    }

    public byte[] getLogTime() {
        return checkNotNull(logTime).getBytes(StandardCharsets.UTF_8);
    }

    public void setLogTime(String logTime) {
        this.logTime = logTime;
    }

    public byte[] getLevel() {
        return checkNotNull(level).getBytes(StandardCharsets.UTF_8);
    }

    public Long getCid() {
        return checkNotNull(cid);
    }

    public Long getPid() {
        return nvl(pid, 0L);
    }

    public Long getReqid() {
        return checkNotNull(reqid);
    }

    public byte[] getUuid() {
        return checkNotNull(uuid).getBytes(StandardCharsets.UTF_8);
    }

    public Long getShard() {
        return checkNotNull(shard);
    }

    public byte[] getParType(){
        return checkNotNull(parType).getBytes(StandardCharsets.UTF_8);
    }

    public Long getIterId() {
        return checkNotNull(iterId);
    }

    public byte[] getLogType() {
        return LOG_TYPE;
    }

    public byte[] getLogHost() {
        return checkNotNull(logHost).getBytes(StandardCharsets.UTF_8);
    }

    public Long getActualInDirectDbAt() {
        return checkNotNull(actualInDirectDbAt);
    }
}
