package ru.yandex.direct.jobs.logs.serializer;

import java.util.function.Function;

import ru.yandex.yt.ytclient.tables.ColumnSchema;
import ru.yandex.yt.ytclient.tables.ColumnValueType;

class YtColumnSpec<T> {
    private final String name;
    private final String group;
    private final ColumnValueType type;
    private final boolean required;
    private final Function<T, Object> getter;

    YtColumnSpec(String name, ColumnValueType type, boolean required, String group,
                 Function<T, Object> getter) {
        this.name = name;
        this.type = type;
        this.group = group;
        this.required = required;
        this.getter = getter;
    }

    ColumnSchema getSchema() {
        ColumnSchema.Builder builder = new ColumnSchema.Builder(name, type, required);
        if (group != null) {
            builder = builder.setGroup(group);
        }
        return builder.build();
    }

    Object getValue(T object){
        return getter.apply(object);
    }

     ColumnValueType getType() {
        return type;
    }
}
