package ru.yandex.direct.jobs.misprints.service

import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.misprints.MisprintFixlistRepository
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtField
import ru.yandex.direct.ytwrapper.model.YtOperator
import ru.yandex.direct.ytwrapper.model.YtTable
import ru.yandex.inside.yt.kosher.cypress.YPath

@Service
class ImportMisprintFixlistService @Autowired constructor(private val provider: YtProvider,
                                                          private val misprintRepository: MisprintFixlistRepository) {

    private val logger = LoggerFactory.getLogger(ImportMisprintFixlistService::class.java)

    fun updateMisprintFixlist(ytClusterToUpdateFrom: YtCluster, yPath: YPath) {
        logger.info("Importing $ytClusterToUpdateFrom / $yPath")
        val ytOperator: YtOperator = provider.getOperator(ytClusterToUpdateFrom)
        val table = YtTable(yPath.toString())
        val misprints: List<String> = ytOperator.readTableField(table, YtField("word", String::class.java))
        logger.info("Now have " + misprints.size + " words in table")

        val actualMisprints = misprintRepository.getMisprints();
        val toDelete = actualMisprints.asSequence().minus(misprints).toList();
        val toInsert = misprints.asSequence().minus(actualMisprints).toList();

        logger.info("Got " + toInsert.size + " misprints to insert")
        misprintRepository.insertMisprints(toInsert)
        logger.info("Got " + toDelete.size + " misprints to delete")
        misprintRepository.deleteMisprints(toDelete)
    }

}
