package ru.yandex.direct.jobs.moatexport;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;


public class MoatUtils {
    private MoatUtils() {

    }

    public static void uploadToFtp(String host, int port, String username, String password, String path,
                                   String filename,
                                   String dataForUpload) throws IOException, JSchException, SftpException {
        JSch jSch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(dataForUpload.getBytes())) {
            session = jSch.getSession(username, host, port);
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();

            channelSftp = (ChannelSftp) session.openChannel("sftp");
            channelSftp.connect();

            channelSftp.cd(path);
            channelSftp.put(is, filename);
        } finally {
            if (channelSftp != null && channelSftp.isConnected()) {
                channelSftp.exit();
            }
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }
}
