package ru.yandex.direct.jobs.mobileappsiosskadnetworkslots;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.CampaignOpts;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsArchived;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentOsType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_APPS;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT;

@Repository
@ParametersAreNonnullByDefault
public class RmpCampaignRepository {

    private final DslContextProvider dslContextProvider;

    public RmpCampaignRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public List<Long> getStoppedCampaignIds(
            int shard, LocalDateTime timeThreshold, Long lastId, int limit) {
        return dslContextProvider.ppc(shard)
                .select(CAMPAIGNS.CID)
                .from(CAMPAIGNS)
                .join(CAMPAIGNS_MOBILE_CONTENT).on(CAMPAIGNS.CID.eq(CAMPAIGNS_MOBILE_CONTENT.CID))
                .join(MOBILE_APPS).on(CAMPAIGNS_MOBILE_CONTENT.MOBILE_APP_ID.eq(MOBILE_APPS.MOBILE_APP_ID))
                .join(MOBILE_CONTENT).on(MOBILE_APPS.MOBILE_CONTENT_ID.eq(MOBILE_CONTENT.MOBILE_CONTENT_ID.cast(MOBILE_APPS.MOBILE_CONTENT_ID.getDataType())))
                .where(MOBILE_CONTENT.BUNDLE_ID.isNotNull())
                .and(MOBILE_CONTENT.BUNDLE_ID.notEqual(""))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.Yes))
                .and(CAMPAIGNS.LAST_SHOW_TIME.lessOrEqual(timeThreshold))
                .and(CAMPAIGNS.OPTS.contains(CampaignOpts.IS_SKADNETWORK_ENABLED.getTypedValue()))
                .and(CAMPAIGNS.CID.greaterThan(lastId))
                .orderBy(CAMPAIGNS.CID)
                .limit(limit)
                .fetch(CAMPAIGNS.CID);
    }

    public Map<String, List<Long>> getCampaignsWithVerificationFlagIOS(
            int shard, boolean verificationFlag, Long lastId, int limit) {
        return dslContextProvider.ppc(shard)
                .select(MOBILE_CONTENT.BUNDLE_ID, CAMPAIGNS.CID)
                .from(CAMPAIGNS)
                .join(CAMPAIGNS_MOBILE_CONTENT).on(CAMPAIGNS.CID.eq(CAMPAIGNS_MOBILE_CONTENT.CID))
                .join(MOBILE_APPS).on(CAMPAIGNS_MOBILE_CONTENT.MOBILE_APP_ID.eq(MOBILE_APPS.MOBILE_APP_ID))
                .join(MOBILE_CONTENT).on(MOBILE_APPS.MOBILE_CONTENT_ID.eq(MOBILE_CONTENT.MOBILE_CONTENT_ID.cast(MOBILE_APPS.MOBILE_CONTENT_ID.getDataType())))
                .where(MOBILE_CONTENT.BUNDLE_ID.isNotNull())
                .and(MOBILE_CONTENT.BUNDLE_ID.notEqual(""))
                .and(MOBILE_APPS.HAS_IDENTIFIED_POSTBACKS.eq(verificationFlag ? 1L : 0L))
                .and(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.No))
                .and(CAMPAIGNS.OPTS.contains(CampaignOpts.IS_SKADNETWORK_ENABLED.getTypedValue()))
                .and(CAMPAIGNS.CID.greaterThan(lastId))
                .and(MOBILE_CONTENT.OS_TYPE.eq(MobileContentOsType.iOS))
                .orderBy(CAMPAIGNS.CID)
                .limit(limit)
                .fetchGroups(MOBILE_CONTENT.BUNDLE_ID, CAMPAIGNS.CID);
    }

    public List<Long> getSkadUnAllowedCampaigns(
            int shard, LocalDateTime timeThreshold, List<Long> campaignIdsWithSlot) {
        return dslContextProvider.ppc(shard)
                .select(CAMPAIGNS.CID)
                .from(CAMPAIGNS)
                .join(CAMPAIGNS_MOBILE_CONTENT).on(CAMPAIGNS.CID.eq(CAMPAIGNS_MOBILE_CONTENT.CID))
                .join(MOBILE_APPS).on(CAMPAIGNS_MOBILE_CONTENT.MOBILE_APP_ID.eq(MOBILE_APPS.MOBILE_APP_ID))
                .join(MOBILE_CONTENT).on(MOBILE_APPS.MOBILE_CONTENT_ID.eq(MOBILE_CONTENT.MOBILE_CONTENT_ID.cast(MOBILE_APPS.MOBILE_CONTENT_ID.getDataType())))
                .where(CAMPAIGNS.CID.in(campaignIdsWithSlot))
                .and(CAMPAIGNS.OPTS.notContains(CampaignOpts.IS_SKADNETWORK_ENABLED.getTypedValue())
                        .or(CAMPAIGNS.ARCHIVED.eq(CampaignsArchived.Yes))
                )
                .and(CAMPAIGNS.LAST_SHOW_TIME.lessOrEqual(timeThreshold))
                .fetch(CAMPAIGNS.CID);
    }
}
