package ru.yandex.direct.jobs.mobileappsverification;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class UidWithStoreAppId {
    private final Long uid;
    private final String storeAppId;

    public UidWithStoreAppId(Long uid, String storeAppId) {
        this.uid = uid;
        this.storeAppId = storeAppId;
    }

    public Long getUid() {
        return uid;
    }

    public String getStoreAppId() {
        return storeAppId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UidWithStoreAppId that = (UidWithStoreAppId) o;

        if (!uid.equals(that.uid)) {
            return false;
        }
        return storeAppId.equals(that.storeAppId);
    }

    @Override
    public int hashCode() {
        int result = uid.hashCode();
        result = 31 * result + storeAppId.hashCode();
        return result;
    }
}
