package ru.yandex.direct.jobs.moderation;

import java.util.List;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;
import ru.yandex.direct.jobs.moderation.processor.ModerationResponseProcessorFilter;
import ru.yandex.direct.utils.Interrupts;

public abstract class BaseModerationResponseProcessor<T extends AbstractModerationResponse> implements Interrupts.InterruptibleConsumer<List<T>> {

    private final ModerationResponseProcessorFilter filter;

    public BaseModerationResponseProcessor(ModerationResponseProcessorFilter filter) {
        this.filter = filter;
    }

    @Override
    public void accept(List<T> value) {
        List<T> filteredValues = filter.filter(value);
        processResponses(filteredValues);
    }

    protected abstract void processResponses(List<T> responses);
}
