package ru.yandex.direct.jobs.moderation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.monlib.metrics.primitives.Counter;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Общий класс с метриками для {@link ReceiveModerationResponseJob}
 */
@ParametersAreNonnullByDefault
public class ModerationReadMonitoring {
    private final MetricRegistry metricRegistry;
    private final Map<ModerationObjectType, Counter> counters;
    private final Counter errorCounter;
    private final Counter jsonParseErrorsCounter;

    private static final String ERROR_UNKNOWN_MODERATION_VERDICT = "error_unknown_operator_verdict";
    private static final String ERROR_JSON_PARSE = "error_json_parse";

    public ModerationReadMonitoring(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.errorCounter = metricRegistry.counter(ERROR_UNKNOWN_MODERATION_VERDICT);
        this.jsonParseErrorsCounter = metricRegistry.counter(ERROR_JSON_PARSE);
        this.counters = new ConcurrentHashMap<>();
    }

    public void incProcessedResponses(ModerationObjectType type, int n) {
        Counter counter = counters.computeIfAbsent(type, t -> metricRegistry.counter(t.getValue() +
                "_moderation_response"));
        counter.add(n);
    }

    /**
     * Увеличение количества неизвестных вердиктов
     */
    public void incErrorUnknownModerationVerdict(int n) {
        errorCounter.add(n);
    }

    /**
     * Увеличение количества ошибок парсинга
     */
    public void incErrorJsonParse(int n) {
        jsonParseErrorsCounter.add(n);
    }

}

