package ru.yandex.direct.jobs.moderation;

import java.util.IdentityHashMap;
import java.util.List;

import static java.util.function.Predicate.not;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

public class ModerationUtils {
    private ModerationUtils() {
        // no instantiating
    }

    /**
     * Удаляет из первого списка те объекты, которые находятся во втором.
     * При этом эквивалентность определяется как elem1 == elem2,
     * то есть если это действительно один и тот же экземпляр.
     */
    public static <T> List<T> subtractByIdentity(List<T> a, List<T> b) {
        IdentityHashMap<T, ?> map = new IdentityHashMap<>();
        b.forEach(bItem -> map.put(bItem, null));
        return filterList(a, not(map::containsKey));
    }
}
