package ru.yandex.direct.jobs.moderation;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.binlogbroker.logbroker_utils.reader.impl.LogbrokerBatchReaderImpl;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.common.log.service.ModerationLogService;
import ru.yandex.direct.core.entity.moderation.model.ModerationError;
import ru.yandex.direct.env.ProductionOnly;
import ru.yandex.direct.env.TypicalEnvironment;
import ru.yandex.direct.jobs.moderation.config.ErrorLogbrokerConsumerPropertiesHolder;
import ru.yandex.direct.jobs.moderation.config.ResponseModerationParameters;
import ru.yandex.direct.jobs.moderation.errors.ModerationErrorCodeToJugglerStatus;
import ru.yandex.direct.jobs.moderation.processor.ModerationResponseProcessorFilter;
import ru.yandex.direct.jobs.moderation.reader.ModerationErrorLogbrokerReader;
import ru.yandex.direct.juggler.check.annotation.JugglerCheck;
import ru.yandex.direct.juggler.check.model.CheckTag;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.ParameterizedBy;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;

import static ru.yandex.direct.juggler.check.model.CheckTag.DIRECT_PRIORITY_0_UNSTABLE;

/**
 * Джоба читает топик модерации, в которой присылаются заявки, которые не смогли быть обработаны по какой-то причине
 * Если в этой очереди есть записи, то нужно обратить внимание, поэтому взводим crit в джаглере
 */
@JugglerCheck(ttl = @JugglerCheck.Duration(minutes = 15 + 1),
        tags = {DIRECT_PRIORITY_0_UNSTABLE, CheckTag.DIRECT_PRODUCT_TEAM},
        needCheck = ProductionOnly.class
)
@Hourglass(periodInSeconds = 5 * 60, needSchedule = TypicalEnvironment.class)
@ParameterizedBy(parametersSource = ErrorLogbrokerConsumerPropertiesHolder.class)
@ParametersAreNonnullByDefault
public class ReceiveModerationErrorResponseJob extends BaseReceiveModerationJob<ModerationError> {

    private final ModerationLogService moderationLogService;
    private final ModerationErrorCodeToJugglerStatus moderationErrorCodeToJugglerStatus;
    private final PpcPropertiesSupport propertiesSupport;

    @Autowired
    public ReceiveModerationErrorResponseJob(ResponseModerationParameters moderationParameters,
                                             ModerationResponseProcessorFilter processorFilter,
                                             ErrorLogbrokerConsumerPropertiesHolder logbrokerConsumerProperties,
                                             ReceiveModerationService receiveModerationService,
                                             ModerationLogService moderationLogService,
                                             ModerationErrorCodeToJugglerStatus moderationErrorCodeToJugglerStatus,
                                             PpcPropertiesSupport propertiesSupport) {
        super(moderationParameters, processorFilter, logbrokerConsumerProperties, receiveModerationService);
        this.moderationLogService = moderationLogService;
        this.moderationErrorCodeToJugglerStatus = moderationErrorCodeToJugglerStatus;
        this.propertiesSupport = propertiesSupport;
    }

    @Override
    protected LogbrokerBatchReaderImpl<ModerationError> getLogbrokerBatchReader(Supplier<SyncConsumer> syncConsumerSupplier) {
        return new ModerationErrorLogbrokerReader(
                syncConsumerSupplier, moderationParameters, getMetricRegistry(), propertiesSupport);
    }

    @Override
    protected BaseModerationResponseProcessor<ModerationError> getEventsProcessor() {
        return new ModerationErrorResponseProcessor(processorFilter, getMetricRegistry(), moderationLogService,
                this::setJugglerStatus,
                moderationErrorCodeToJugglerStatus);
    }

}
