package ru.yandex.direct.jobs.moderation;

import java.util.function.Supplier;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import ru.yandex.direct.ess.common.logbroker.LogbrokerClientFactoryFacade;
import ru.yandex.direct.ess.common.logbroker.LogbrokerConsumerProperties;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;

import static ru.yandex.direct.logicprocessor.configuration.EssLogicProcessorConfiguration.MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME;

@Service
public class ReceiveModerationService {

    private final LogbrokerClientFactoryFacade logbrokerClientFactory;

    public ReceiveModerationService(@Qualifier(MODERATION_LOGBROKER_CLIENT_FACTORY_BEAN_NAME) LogbrokerClientFactoryFacade logbrokerClientFactory) {
        this.logbrokerClientFactory = logbrokerClientFactory;
    }

    public Supplier<SyncConsumer> createConsumerSupplier(LogbrokerConsumerProperties consumerProperties) {
       return logbrokerClientFactory.createConsumerSupplier(consumerProperties);
    }
}
