package ru.yandex.direct.jobs.moderation.config;

import java.util.Objects;

/**
 * Информация о целевом топике, в который будут перенаправляться (джобой роутинга) вердикты
 */
public class DestConfig {
    // Название топика
    private final String topic;
    // На сколько групп партиций шардируем вердикты
    private final int groupsCnt;

    public DestConfig(String topic, int groupsCnt) {
        this.topic = Objects.requireNonNull(topic);
        this.groupsCnt = groupsCnt;
    }

    public String getTopic() {
        return topic;
    }

    public int getGroupsCnt() {
        return groupsCnt;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DestConfig destConfig = (DestConfig) o;
        return groupsCnt == destConfig.groupsCnt &&
                topic.equals(destConfig.topic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(topic, groupsCnt);
    }
}
