package ru.yandex.direct.jobs.moderation.config;

import java.util.List;

public class ErrorLogbrokerConsumerPropertiesHolder extends LogbrokerConsumerPropertiesHolder {
    private ErrorLogbrokerConsumerPropertiesHolder(String logbrokerHost,
                                                   String consumerName,
                                                   int logbrokerDataTimeoutSec,
                                                   int logbrokerInitTimeoutSec,
                                                   int retries,
                                                   List<Integer> groups,
                                                   String logbrokerTopic,
                                                   Long readDataAfterTimestampMs) {
        super(logbrokerHost, logbrokerTopic, consumerName, logbrokerDataTimeoutSec, logbrokerInitTimeoutSec, retries,
                groups, readDataAfterTimestampMs);
    }

    public static ErrorLogbrokerConsumerPropertiesHolderBuilder builder() {
        return new ErrorLogbrokerConsumerPropertiesHolderBuilder();
    }


    public static final class ErrorLogbrokerConsumerPropertiesHolderBuilder {
        private String host;
        private String readTopic;
        private String consumerName;
        private int logbrokerDataTimeoutSec;
        private int initTimeoutSec;
        private int retries;
        private List<Integer> groups;
        private Long readDataAfterTimestampMs;

        private ErrorLogbrokerConsumerPropertiesHolderBuilder() {
        }

        public static ErrorLogbrokerConsumerPropertiesHolderBuilder anErrorLogbrokerConsumerPropertiesHolder() {
            return new ErrorLogbrokerConsumerPropertiesHolderBuilder();
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withReadTopic(String readTopic) {
            this.readTopic = readTopic;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withLogbrokerDataTimeoutSec(int logbrokerDataTimeoutSec) {
            this.logbrokerDataTimeoutSec = logbrokerDataTimeoutSec;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withInitTimeoutSec(int initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolderBuilder withReadDataAfterTimestampMs(Long readDataAfterTimestampMs) {
            this.readDataAfterTimestampMs = readDataAfterTimestampMs;
            return this;
        }

        public ErrorLogbrokerConsumerPropertiesHolder build() {
            return new ErrorLogbrokerConsumerPropertiesHolder(host, consumerName, logbrokerDataTimeoutSec,
                    initTimeoutSec, retries, groups, readTopic, readDataAfterTimestampMs);
        }
    }
}
