package ru.yandex.direct.jobs.moderation.config;

import java.util.List;
import java.util.Map;

public class ResponseModerationLogbrokerConsumerPropertiesHolder extends LogbrokerConsumerPropertiesHolder {

    private ResponseModerationLogbrokerConsumerPropertiesHolder(String logbrokerHost,
                                                                String consumerName,
                                                                int logbrokerDataTimeoutSec,
                                                                int logbrokerInitTimeoutSec,
                                                                int retries,
                                                                Long readDataAfterTimestampMs,
                                                                Map<String, List<Integer>> readTopicsGroups) {

        super(logbrokerHost, consumerName, logbrokerDataTimeoutSec, logbrokerInitTimeoutSec, retries,
                readDataAfterTimestampMs, readTopicsGroups);
    }

    public static ResponseModerationLogbrokerConsumerPropertiesHolderBuilder builder() {
        return new ResponseModerationLogbrokerConsumerPropertiesHolderBuilder();
    }

    public static final class ResponseModerationLogbrokerConsumerPropertiesHolderBuilder {
        private String host;
        private String consumerName;
        private int logbrokerDataTimeoutSec;
        private int initTimeoutSec;
        private int retries;
        private Long readDataAfterTimestampMs;
        Map<String, List<Integer>> readTopicsGroups;

        private ResponseModerationLogbrokerConsumerPropertiesHolderBuilder() {
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withLogbrokerDataTimeoutSec(int logbrokerDataTimeoutSec) {
            this.logbrokerDataTimeoutSec = logbrokerDataTimeoutSec;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withInitTimeoutSec(int initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withReadTopicsGroups(Map<String,
                List<Integer>> readTopicsGroups) {
            this.readTopicsGroups = readTopicsGroups;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolderBuilder withReadDataAfterTimestampMs(Long readDataAfterTimestampMs) {
            this.readDataAfterTimestampMs = readDataAfterTimestampMs;
            return this;
        }

        public ResponseModerationLogbrokerConsumerPropertiesHolder build() {
            return new ResponseModerationLogbrokerConsumerPropertiesHolder(host, consumerName,
                    logbrokerDataTimeoutSec, initTimeoutSec, retries, readDataAfterTimestampMs, readTopicsGroups);
        }
    }
}
