package ru.yandex.direct.jobs.moderation.config;

public class ResponseModerationParameters {
    private final boolean logbrokerNoCommit;

    private ResponseModerationParameters(boolean logbrokerNoCommit) {
        this.logbrokerNoCommit = logbrokerNoCommit;
    }

    public boolean isLogbrokerNoCommit() {
        return logbrokerNoCommit;
    }

    public static class Builder {
        private boolean logbrokerNoCommit;

        public Builder setLogbrokerNoCommit(boolean logbrokerNoCommit) {
            this.logbrokerNoCommit = logbrokerNoCommit;
            return this;
        }

        public ResponseModerationParameters build() {
            return new ResponseModerationParameters(logbrokerNoCommit);
        }
    }
}
