package ru.yandex.direct.jobs.moderation.config;

import java.util.List;

/**
 * Источник набора параметров для джобы {@link ru.yandex.direct.jobs.moderation.ReceiveModerationResponseRouterJob}
 */
public class ResponseRoutingLogbrokerConsumerPropertiesHolder extends LogbrokerConsumerPropertiesHolder {
    public ResponseRoutingLogbrokerConsumerPropertiesHolder(String host, String consumerName,
                                                            int logbrokerDataTimeoutSec, int initTimeoutSec,
                                                            int retries, Long readDataAfterTimestampMs,
                                                            String readTopic, List<Integer> groups) {
        super(host, readTopic, consumerName, logbrokerDataTimeoutSec, initTimeoutSec, retries, groups,
                readDataAfterTimestampMs);
    }

    public static ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder builder() {
        return new ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder();
    }

    public static final class ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder {
        private String host;
        private String readTopic;
        private String consumerName;
        private int logbrokerDataTimeoutSec;
        private int initTimeoutSec;
        private int retries;
        private List<Integer> groups;
        private Long readDataAfterTimestampMs;

        private ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder() {
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withReadTopic(String readTopic) {
            this.readTopic = readTopic;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withLogbrokerDataTimeoutSec(int logbrokerDataTimeoutSec) {
            this.logbrokerDataTimeoutSec = logbrokerDataTimeoutSec;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withInitTimeoutSec(int initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolderBuilder withReadDataAfterTimestampMs(Long readDataAfterTimestampMs) {
            this.readDataAfterTimestampMs = readDataAfterTimestampMs;
            return this;
        }

        public ResponseRoutingLogbrokerConsumerPropertiesHolder build() {
            return new ResponseRoutingLogbrokerConsumerPropertiesHolder(host, consumerName, logbrokerDataTimeoutSec,
                    initTimeoutSec, retries, readDataAfterTimestampMs, readTopic, groups);
        }
    }
}
