package ru.yandex.direct.jobs.moderation.config;

import java.util.Map;

import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.kikimr.persqueue.compression.CompressionCodec;

public class ResponseRoutingParameters {
    private final ResponseRoutingLogbrokerConsumerPropertiesHolder consumerProperties;
    private final ProducerProperties producerProperties;

    private final DestConfig defaultWriteTopic;
    private final Map<ModerationObjectType, DestConfig> routesMap;

    public ResponseRoutingParameters(ResponseRoutingLogbrokerConsumerPropertiesHolder consumerProperties,
                                     ProducerProperties producerProperties, DestConfig defaultWriteTopic,
                                     Map<ModerationObjectType, DestConfig> routesMap) {
        this.consumerProperties = consumerProperties;
        this.producerProperties = producerProperties;
        this.defaultWriteTopic = defaultWriteTopic;
        this.routesMap = routesMap;
    }

    public ResponseRoutingLogbrokerConsumerPropertiesHolder getConsumerProperties() {
        return consumerProperties;
    }

    public ProducerProperties getProducerProperties() {
        return producerProperties;
    }

    public DestConfig getDefaultWriteTopic() {
        return defaultWriteTopic;
    }

    public Map<ModerationObjectType, DestConfig> getRoutesMap() {
        return routesMap;
    }

    public static class ProducerProperties {
        private final String logbrokerHost;
        private final long timeoutSec;
        private final int retries;
        private final CompressionCodec compressionCodec;

        public ProducerProperties(String logbrokerHost, long timeoutSec, int retries,
                                  CompressionCodec compressionCodec) {
            this.logbrokerHost = logbrokerHost;
            this.timeoutSec = timeoutSec;
            this.retries = retries;
            this.compressionCodec = compressionCodec;
        }

        public String getLogbrokerHost() {
            return logbrokerHost;
        }

        public long getTimeoutSec() {
            return timeoutSec;
        }

        public int getRetries() {
            return retries;
        }

        public CompressionCodec getCompressionCodec() {
            return compressionCodec;
        }
    }
}
