package ru.yandex.direct.jobs.moderation.config;

import java.util.Objects;

/**
 * Комбинация логброкерного топика и группы партиций
 * Идентифицирует источник чтения для джобы обработки вердиктов модерации
 */
public class TopicWithGroup {
    private final String topic;
    private final Integer group;

    public TopicWithGroup(String topic, Integer group) {
        this.topic = Objects.requireNonNull(topic);
        this.group = Objects.requireNonNull(group);
    }

    public String getTopic() {
        return topic;
    }

    public Integer getGroup() {
        return group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TopicWithGroup that = (TopicWithGroup) o;
        return topic.equals(that.topic) &&
                group.equals(that.group);
    }

    @Override
    public int hashCode() {
        return Objects.hash(topic, group);
    }

    @Override
    public String toString() {
        return "TopicWithGroup{" +
                ", topic='" + topic + '\'' +
                ", group=" + group +
                '}';
    }
}
