package ru.yandex.direct.jobs.moderation.config;

import java.util.List;

public class UnparsedLogbrokerConsumerPropertiesHolder extends LogbrokerConsumerPropertiesHolder {
    private UnparsedLogbrokerConsumerPropertiesHolder(String logbrokerHost,
                                                      String consumerName,
                                                      int logbrokerDataTimeoutSec,
                                                      int logbrokerInitTimeoutSec,
                                                      int retries,
                                                      List<Integer> groups,
                                                      String logbrokerTopic,
                                                      Long readDataAfterTimestampMs) {
        super(logbrokerHost, logbrokerTopic, consumerName, logbrokerDataTimeoutSec, logbrokerInitTimeoutSec, retries,
                groups, readDataAfterTimestampMs);
    }

    public static UnparsedLogbrokerConsumerPropertiesHolderBuilder builder() {
        return new UnparsedLogbrokerConsumerPropertiesHolderBuilder();
    }

    public static final class UnparsedLogbrokerConsumerPropertiesHolderBuilder {
        private String host;
        private String readTopic;
        private String consumerName;
        private int logbrokerDataTimeoutSec;
        private int initTimeoutSec;
        private int retries;
        private List<Integer> groups;
        private Long readDataAfterTimestampMs;

        private UnparsedLogbrokerConsumerPropertiesHolderBuilder() {
        }

        public static UnparsedLogbrokerConsumerPropertiesHolderBuilder anUnparsedLogbrokerConsumerPropertiesHolder() {
            return new UnparsedLogbrokerConsumerPropertiesHolderBuilder();
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withReadTopic(String readTopic) {
            this.readTopic = readTopic;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withConsumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withLogbrokerDataTimeoutSec(int logbrokerDataTimeoutSec) {
            this.logbrokerDataTimeoutSec = logbrokerDataTimeoutSec;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withInitTimeoutSec(int initTimeoutSec) {
            this.initTimeoutSec = initTimeoutSec;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withGroups(List<Integer> groups) {
            this.groups = groups;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolderBuilder withReadDataAfterTimestampMs(Long readDataAfterTimestampMs) {
            this.readDataAfterTimestampMs = readDataAfterTimestampMs;
            return this;
        }

        public UnparsedLogbrokerConsumerPropertiesHolder build() {
            return new UnparsedLogbrokerConsumerPropertiesHolder(host, consumerName, logbrokerDataTimeoutSec,
                    initTimeoutSec, retries, groups, readTopic, readDataAfterTimestampMs);
        }
    }
}
