package ru.yandex.direct.jobs.moderation.errors;

import java.util.Map;

import ru.yandex.direct.core.entity.moderation.model.ModerationErrorToken;
import ru.yandex.direct.juggler.JugglerStatus;

public class ModerationErrorCodeToJugglerStatus {
    private final Map<ModerationErrorToken, JugglerStatus> mapping;

    public ModerationErrorCodeToJugglerStatus(Map<ModerationErrorToken, JugglerStatus> mapping) {
        this.mapping = Map.copyOf(mapping);
    }

    public JugglerStatus getJugglerStatus(ModerationErrorToken code) {
        if (code == null) {
            return JugglerStatus.CRIT;
        }

        return mapping.getOrDefault(code, JugglerStatus.CRIT);
    }
}
