package ru.yandex.direct.jobs.moderation.processor;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;

public class ModerationResponseProcessorFilter {

    private Predicate<AbstractModerationResponse> filter;

    private ModerationResponseProcessorFilter() {
    }

    public ModerationResponseProcessorFilter(@Nonnull Predicate<AbstractModerationResponse> filter) {
        this.filter = filter;
    }

    public <T extends AbstractModerationResponse> List<T> filter(List<T> responses) {
        return Objects.isNull(filter) ?
                responses : filterList(responses, filter);
    }

    public void addFilter(Predicate<AbstractModerationResponse> newFilter) {
        if (Objects.isNull(filter)) {
            filter = newFilter;
        }
        this.filter = filter.and(newFilter);
    }

    public static ModerationResponseProcessorFilter doNothing() {
        return new ModerationResponseProcessorFilter();
    }

}
