package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.BannerButtonModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.BANNER_BUTTONS;

@Component
@Scope(SCOPE_PROTOTYPE)
public class BannerButtonModerationResponseHandler extends BaseModerationHandler<BannerAssetModerationResponse> {

    @Autowired
    public BannerButtonModerationResponseHandler(
            BannerButtonModerationReceivingService bannerButtonModerationReceivingService) {
        super(bannerButtonModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return BANNER_BUTTONS;
    }

}
