package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.BannerLogoModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.BANNER_LOGOS;

@Component
@Scope(SCOPE_PROTOTYPE)
public class BannerLogoModerationResponseHandler extends BaseModerationHandler<BannerAssetModerationResponse> {

    @Autowired
    public BannerLogoModerationResponseHandler(
            BannerLogoModerationReceivingService bannerLogoModerationReceivingService) {
        super(bannerLogoModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return BANNER_LOGOS;
    }

}
