package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.callout.CalloutModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.CalloutModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.CALLOUT;

@Component
@Scope(SCOPE_PROTOTYPE)
public class CalloutModerationResponseHandler extends BaseModerationHandler<CalloutModerationResponse> {

    @Autowired
    public CalloutModerationResponseHandler(
            CalloutModerationReceivingService calloutModerationReceivingService) {
        super(calloutModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return CALLOUT;
    }

}
