package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.ContentPromotionCollectionModerationResponseReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
public class ContentPromotionCollectionModerationResponseHandler extends BaseModerationHandler<BannerModerationResponse> {

    @Autowired
    public ContentPromotionCollectionModerationResponseHandler(
            ContentPromotionCollectionModerationResponseReceivingService contentPromotionCollectionModerationResponseReceivingService) {
        super(contentPromotionCollectionModerationResponseReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.CONTENT_PROMOTION_COLLECTION;
    }

}
