package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.CpmGeoPinModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
public class CpmGeoPinModerationResponseHandler extends BaseModerationHandler<BannerModerationResponse> {


    @Autowired
    public CpmGeoPinModerationResponseHandler(
            CpmGeoPinModerationReceivingService cpmGeoPinModerationReceivingService) {
        super(cpmGeoPinModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.GEO_PIN_CREATIVE;
    }

}
