package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.CpmVideoBannerModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
public class CpmVideoBannerModerationResponseHandler extends BaseModerationHandler<BannerModerationResponse> {

    @Autowired
    public CpmVideoBannerModerationResponseHandler(
            CpmVideoBannerModerationReceivingService cpmVideoBannerModerationReceivingService) {
        super(cpmVideoBannerModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.CPM_VIDEO;
    }

}
