package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.displayhrefs.DisplayHrefsModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.DisplayHrefsModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.DISPLAYHREFS;

@Component
@Scope(SCOPE_PROTOTYPE)
public class DisplayHrefsModerationResponseHandler extends BaseModerationHandler<DisplayHrefsModerationResponse> {

    @Autowired
    public DisplayHrefsModerationResponseHandler(
            DisplayHrefsModerationReceivingService displayHrefsModerationReceivingService) {
        super(displayHrefsModerationReceivingService);
    }


    @Override
    public ModerationObjectType getType() {
        return DISPLAYHREFS;
    }

}
