package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.FixCpmYndxFrontpageModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
public class FixCpmYndxFrontpageModerationResponseHandler extends BaseModerationHandler<BannerModerationResponse> {

    @Autowired
    public FixCpmYndxFrontpageModerationResponseHandler(
            FixCpmYndxFrontpageModerationReceivingService moderationReceivingService) {
        super(moderationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.FIXCPM_YNDX_FRONTPAGE_CREATIVE;
    }

}
