package ru.yandex.direct.jobs.moderation.processor.handlers;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.Html5ModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
@ParametersAreNonnullByDefault
public class Html5ModerationResponseHandler extends BaseModerationHandler<BannerModerationResponse> {

    @Autowired
    public Html5ModerationResponseHandler(Html5ModerationReceivingService moderationReceivingService) {
        super(moderationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.HTML5;
    }
}
