package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.image.ImageModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.ImageModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.IMAGES;

@Component
@Scope(SCOPE_PROTOTYPE)
public class ImageModerationResponseHandler extends BaseModerationHandler<ImageModerationResponse> {

    @Autowired
    public ImageModerationResponseHandler(
            ImageModerationReceivingService imageModerationReceivingService) {
        super(imageModerationReceivingService);
    }


    @Override
    public ModerationObjectType getType() {
        return IMAGES;
    }

}
