package ru.yandex.direct.jobs.moderation.processor.handlers;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.BannerModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.InternalBannerModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
@ParametersAreNonnullByDefault
public class InternalBannerModerationResponseHandler extends BaseModerationHandler<BannerModerationResponse> {

    @Autowired
    public InternalBannerModerationResponseHandler(
            InternalBannerModerationReceivingService internalBannerModerationReceivingService) {
        super(internalBannerModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.INTERNAL_BANNER;
    }

}
