package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.mobilecontenticon.MobileContentIconModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.MobileContentIconModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;

@Component
@Scope(SCOPE_PROTOTYPE)
public class MobileContentIconModerationResponseHandler
        extends BaseModerationHandler<MobileContentIconModerationResponse> {
    public MobileContentIconModerationResponseHandler(
            MobileContentIconModerationReceivingService mobileContentIconModerationReceivingService) {
        super(mobileContentIconModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.MOBILE_CONTENT_ICON;
    }
}
