package ru.yandex.direct.jobs.moderation.processor.handlers;

import java.util.List;
import java.util.function.Function;

import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.jobs.moderation.ModerationReadMonitoring;

public interface ModerationResponseHandler<T extends AbstractModerationResponse> {

    /**
     * Тип преобразуется из AbstractModerationResponse.getType()
     * Если тип не известен, то устанавливается ModerationType.UNKNOWN
     */
    ModerationObjectType getType();

    /**
     * функция для получения clientId из соответствующего вердикта T
     * Используется для определения шарда
     */
    Function<T, Long> getClientIDExtractor();

    /**
     *
     * @param shard номер шарда
     * @param responses список для обработки
     * @param readMonitoring различные метрики
     * @return успешно обработанные ответы
     */
    List<T> handleResponses(int shard, List<T> responses, ModerationReadMonitoring readMonitoring);

}
