package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.sitelinks.SitelinksModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.SitelinksModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.SITELINKS_SET;

@Component
@Scope(SCOPE_PROTOTYPE)
public class SitelinksModerationResponseHandler extends BaseModerationHandler<SitelinksModerationResponse> {

    @Autowired
    public SitelinksModerationResponseHandler(
            SitelinksModerationReceivingService sitelinksModerationReceivingService) {
        super(sitelinksModerationReceivingService);
    }


    @Override
    public ModerationObjectType getType() {
        return SITELINKS_SET;
    }

}
