package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.turbolandings.TurbolandingsModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.TurbolandingModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.TURBOLANDINGS;

@Component
@Scope(SCOPE_PROTOTYPE)
public class TurbolandingsModerationResponseHandler extends BaseModerationHandler<TurbolandingsModerationResponse> {

    @Autowired
    public TurbolandingsModerationResponseHandler(
            TurbolandingModerationReceivingService turbolandingModerationReceivingService) {
        super(turbolandingModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return TURBOLANDINGS;
    }

}
