package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.VcardModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.BANNER_VCARD;

@Component
@Scope(SCOPE_PROTOTYPE)
public class VcardModerationResponseHandler extends BaseModerationHandler<BannerAssetModerationResponse> {

    @Autowired
    public VcardModerationResponseHandler(
            VcardModerationReceivingService bannerVcardModerationReceivingService) {
        super(bannerVcardModerationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return BANNER_VCARD;
    }

}
