package ru.yandex.direct.jobs.moderation.processor.handlers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerVideoAdditionModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.core.entity.moderation.service.receiving.VideoAdditionModerationReceivingService;

import static org.springframework.beans.factory.config.ConfigurableBeanFactory.SCOPE_PROTOTYPE;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.BANNER_VIDEO_ADDITION;

@Component
@Scope(SCOPE_PROTOTYPE)
public class VideoAdditionModerationResponseHandler extends BaseModerationHandler<BannerVideoAdditionModerationResponse> {

    @Autowired
    public VideoAdditionModerationResponseHandler(
            VideoAdditionModerationReceivingService moderationReceivingService) {
        super(moderationReceivingService);
    }

    @Override
    public ModerationObjectType getType() {
        return BANNER_VIDEO_ADDITION;
    }

}
