package ru.yandex.direct.jobs.moderation.reader;

import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResponse;
import ru.yandex.direct.jobs.moderation.config.ResponseModerationParameters;
import ru.yandex.direct.jobs.moderation.reader.support.ModerationResponseSupportFacade;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@ParametersAreNonnullByDefault
public class ModerationResponseLogbrokerReader extends BaseModerationLogbrokerReader<AbstractModerationResponse> {

    private final ModerationResponseSupportFacade typeSupportService;

    public ModerationResponseLogbrokerReader(
            Supplier<SyncConsumer> logbrokerConsumerSupplier,
            ResponseModerationParameters parameters,
            MetricRegistry metricRegistry,
            ModerationResponseSupportFacade typeSupportService,
            PpcPropertiesSupport propertiesSupport) {
        super(logbrokerConsumerSupplier, parameters, metricRegistry, propertiesSupport);

        this.typeSupportService = typeSupportService;
    }

    @Override
    protected AbstractModerationResponse parseResponseJson(@Nullable JsonNode json) {
        return typeSupportService.parseResponse(json);
    }
}
