package ru.yandex.direct.jobs.moderation.reader;

import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.moderation.model.ModerationUnparsed;
import ru.yandex.direct.jobs.moderation.config.ResponseModerationParameters;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.kikimr.persqueue.consumer.SyncConsumer;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@ParametersAreNonnullByDefault
public class ModerationUnparsedLogbrokerReader extends BaseModerationLogbrokerReader<ModerationUnparsed> {

    public ModerationUnparsedLogbrokerReader(Supplier<SyncConsumer> logbrokerConsumerSupplier,
                                             ResponseModerationParameters parameters,
                                             MetricRegistry metricRegistry,
                                             PpcPropertiesSupport ppcPropertiesSupport) {
        super(logbrokerConsumerSupplier, parameters, metricRegistry, ppcPropertiesSupport);
    }

    @Override
    protected ModerationUnparsed parseResponseJson(@Nullable JsonNode json) {
        if (json == null) {
            return null;
        }
        return JsonUtils.fromJson(json, ModerationUnparsed.class);
    }
}
