package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.moderation.model.bannerstorage.BannerstorageCreativeModerationResponse;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;

import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.No;
import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.Yes;

@Component
public class BannerstorageCreativeModerationResponseConverter extends
        ModerationResponseConverter<BannerstorageCreativeModerationResponse> {
    @Override
    public ModerationObjectType getType() {
        return ModerationObjectType.BANNERSTORAGE_CREATIVES;
    }

    @Override
    public Class<BannerstorageCreativeModerationResponse> getClassToConvert() {
        return BannerstorageCreativeModerationResponse.class;
    }

    @Override
    protected void checkValidJson(BannerstorageCreativeModerationResponse r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkArgument(r.getMeta().getClientId() != 0, "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getCampaignId() != 0, "campaignId is empty");
        Preconditions.checkArgument(r.getMeta().getAdGroupId() != 0, "campaignId is empty");
        Preconditions.checkArgument(r.getMeta().getBannerId() != 0, "bid is empty");
        Preconditions.checkArgument(r.getMeta().getCreativeId() != 0, "creativeId is empty");
        Preconditions.checkArgument(r.getMeta().getCreativeVersionId() != 0, "creativeVersionId is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId() >= 0, "versionId less than zero");

        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(Yes == r.getResult().getVerdict() || No == r.getResult().getVerdict(),
                "verdict invalid value");
    }
}
