package ru.yandex.direct.jobs.moderation.reader.support;

import com.google.common.base.Preconditions;

import ru.yandex.direct.core.entity.moderation.model.asset.BaseBannerAssetModerationResponse;

import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.No;
import static ru.yandex.direct.core.entity.moderation.model.ModerationDecision.Yes;

public abstract class BaseBannerAssetModerationResponseConverter<T extends BaseBannerAssetModerationResponse<?>>
        extends ModerationResponseConverter<T> {

    @Override
    protected void checkValidJson(T r) {
        Preconditions.checkNotNull(r, "response is empty");

        Preconditions.checkNotNull(r.getMeta(), "meta is empty");

        Preconditions.checkArgument(r.getMeta().getClientId() != 0, "clientId is empty");
        Preconditions.checkArgument(r.getMeta().getBannerId() != 0, "bid is empty");
        Preconditions.checkArgument(r.getMeta().getUid() != 0, "uid is empty");
        Preconditions.checkArgument(r.getMeta().getVersionId()  >= 0, "versionId less than zero");

        Preconditions.checkNotNull(r.getResult(), "result is empty");

        Preconditions.checkNotNull(r.getResult().getVerdict(), "verdict is empty");
        Preconditions.checkArgument(
                Yes.equals(r.getResult().getVerdict()) ||
                        No.equals(r.getResult().getVerdict()),
                "verdict invalid value");
    }
}

